/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Enumeration;

class ScCanvas
extends Canvas {
    Dimension preferredSize;
    Dimension minimumSize;
    Image offImage;
    Image loupe;
    Image ScaledImage;
    Image TriangleImage;
    Image im;
    int loupeX;
    int loupeY;
    boolean showLoupe = false;
    boolean ready = false;
    Graphics offGraphics;
    Graphics loupeGraphics;
    int w;
    int h;
    ptproject project;
    static final int LOUPE_WIDTH = 60;
    public boolean dirty = false;
    public int index;

    public ScCanvas(int n, ptproject ptproject2) {
        this.project = ptproject2;
        this.index = n;
        if (n < 0) {
            return;
        }
        this.im = this.project.gl.utils.ptLoadImage(n);
        if (this.im == null) {
            return;
        }
        this.w = (int)((double)this.im.getWidth(null) * this.project.gl.zoom);
        this.h = (int)((double)this.im.getHeight(null) * this.project.gl.zoom);
        this.dirty = true;
        this.preferredSize = new Dimension(this.w, this.h);
        this.minimumSize = new Dimension(10, 10);
        this.ready = true;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (!this.ready || this.im == null) {
            return;
        }
        if (this.offImage == null) {
            this.offImage = this.createImage(this.w, this.h);
            this.offGraphics = this.offImage.getGraphics();
            this.loupe = this.createImage(60, 60);
            this.loupeGraphics = this.loupe.getGraphics();
            this.TriangleImage = this.createImage(this.w, this.h);
            this.ScaledImage = this.createImage(this.w, this.h);
            this.dirty = true;
        }
        if (this.dirty) {
            this.ScaledImage.getGraphics().drawImage(this.im, 0, 0, this.w, this.h, this);
            if (this.project.gl.showTriangles && this.drawTriangles(this.TriangleImage.getGraphics())) {
                this.InsertTriangles(this.TriangleImage, this.ScaledImage);
            }
            this.drawControlPoints(this.ScaledImage.getGraphics());
            this.dirty = false;
        }
        this.offGraphics.drawImage(this.ScaledImage, 0, 0, this);
        if (((ptScrollPane)this.getParent().getParent()).select && !this.project.gl.mousePressedPoint.equals(this.project.gl.mouseDragPoint)) {
            Point point = this.project.gl.mousePressedPoint;
            Point point2 = this.project.gl.mouseDragPoint;
            this.offGraphics.setColor(Color.black);
            this.offGraphics.drawRect(Math.min(point.x, point2.x), Math.min(point.y, point2.y), Math.abs(point.x - point2.x), Math.abs(point.y - point2.y));
        }
        if (this.showLoupe) {
            this.loupeGraphics.drawImage(this.offImage, 0, 0, 60, 60, this.loupeX - 15, this.loupeY - 15, this.loupeX + 15, this.loupeY + 15, this);
            if (this.project.gl.drag >= 0) {
                this.loupeGraphics.setColor(Color.black);
                this.loupeGraphics.drawOval(24, 24, 12, 12);
            }
            this.offGraphics.drawImage(this.loupe, this.loupeX - 30, this.loupeY - 30, 60, 60, this);
        }
        graphics.drawImage(this.offImage, 0, 0, this.getBackground(), this);
    }

    boolean drawTriangles(Graphics graphics) {
        int n = 0;
        if (this.project.nt == 0) {
            return false;
        }
        graphics.setColor(new Color(0, 0, 0));
        graphics.fillRect(0, 0, this.w, this.h);
        Enumeration enumeration = this.project.tr.elements();
        while (enumeration.hasMoreElements()) {
            try {
                triangle triangle2 = (triangle)enumeration.nextElement();
                if (triangle2.nIm != this.index) continue;
                controlPoint controlPoint2 = (controlPoint)this.project.cp.get(new Integer(triangle2.vert[0]));
                int n2 = controlPoint2.n[0] == this.index ? 0 : 1;
                controlPoint controlPoint3 = (controlPoint)this.project.cp.get(new Integer(triangle2.vert[1]));
                int n3 = controlPoint3.n[0] == this.index ? 0 : 1;
                controlPoint controlPoint4 = (controlPoint)this.project.cp.get(new Integer(triangle2.vert[2]));
                int n4 = controlPoint4.n[0] == this.index ? 0 : 1;
                Polygon polygon = new Polygon(new int[]{(int)(controlPoint2.x[n2] * this.project.gl.zoom), (int)(controlPoint3.x[n3] * this.project.gl.zoom), (int)(controlPoint4.x[n4] * this.project.gl.zoom)}, new int[]{(int)(controlPoint2.y[n2] * this.project.gl.zoom), (int)(controlPoint3.y[n3] * this.project.gl.zoom), (int)(controlPoint4.y[n4] * this.project.gl.zoom)}, 3);
                graphics.setColor(new Color(50, 50, 50));
                graphics.fillPolygon(polygon);
                graphics.setColor(new Color(255, 255, 255));
                graphics.drawPolygon(polygon);
                ++n;
            }
            catch (Exception exception) {}
        }
        return n != 0;
    }

    void drawControlPoints(Graphics graphics) {
        int n = this.index == this.project.gl.leftindex ? this.project.gl.rightindex : this.project.gl.leftindex;
        double d = Double.valueOf(this.project.gl.properties.getProperty("PointRadius"));
        int n2 = (int)(d * 2.0);
        Color color = new Color(Integer.parseInt(this.project.gl.properties.getProperty("SelectColor"), 16));
        Color color2 = new Color(Integer.parseInt(this.project.gl.properties.getProperty("SingleColor"), 16));
        Color color3 = new Color(Integer.parseInt(this.project.gl.properties.getProperty("LinkedColor"), 16));
        Enumeration enumeration = this.project.cp.elements();
        while (enumeration.hasMoreElements()) {
            try {
                int n3;
                int n4;
                controlPoint controlPoint2 = (controlPoint)enumeration.nextElement();
                if (controlPoint2.n[0] == this.index && (this.project.gl.showAllPoints || controlPoint2.n[1] == n)) {
                    n4 = (int)(controlPoint2.x[0] * this.project.gl.zoom - d);
                    n3 = (int)(controlPoint2.y[0] * this.project.gl.zoom - d);
                    if (controlPoint2.select) {
                        graphics.setColor(color);
                    } else if (controlPoint2.n[1] == n) {
                        graphics.setColor(color3);
                    } else {
                        graphics.setColor(color2);
                    }
                    graphics.fillOval(n4, n3, n2, n2);
                    graphics.setColor(Color.black);
                    graphics.drawOval(n4, n3, n2, n2);
                    continue;
                }
                if (controlPoint2.n[1] != this.index || !this.project.gl.showAllPoints && controlPoint2.n[0] != n) continue;
                n4 = (int)(controlPoint2.x[1] * this.project.gl.zoom - d);
                n3 = (int)(controlPoint2.y[1] * this.project.gl.zoom - d);
                if (controlPoint2.select) {
                    graphics.setColor(color);
                } else if (controlPoint2.n[0] == n) {
                    graphics.setColor(color3);
                } else {
                    graphics.setColor(color2);
                }
                graphics.fillOval(n4, n3, n2, n2);
                graphics.setColor(Color.black);
                graphics.drawOval(n4, n3, n2, n2);
            }
            catch (Exception exception) {}
        }
    }

    public void magnify(int n, int n2) {
        this.loupeX = n;
        this.loupeY = n2;
        this.showLoupe = true;
    }

    public void unmagnify() {
        this.showLoupe = false;
    }

    void InsertTriangles(Image image, Image image2) {
        int[] nArray;
        int[] nArray2;
        try {
            nArray2 = new int[this.w * this.h];
        }
        catch (Exception exception) {
            System.out.println("Not enough memory for tpix");
            return;
        }
        try {
            nArray = new int[this.w * this.h];
        }
        catch (Exception exception) {
            System.out.println("Not enough memory for spix");
            return;
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.w, this.h, nArray2, 0, this.w);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        pixelGrabber = new PixelGrabber(image2, 0, 0, this.w, this.h, nArray, 0, this.w);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        int n = 0;
        while (n < this.h) {
            int n2 = n * this.w;
            int n3 = 0;
            while (n3 < this.w) {
                int n4 = n2 + n3;
                int n5 = nArray2[n4] & 0xFFFFFF;
                if (n5 != 0) {
                    int n6;
                    int n7;
                    int n8 = nArray[n4];
                    int n9 = (n8 & 0xFF0000) - (n5 & 0xFF0000);
                    if (n9 < 0) {
                        n9 = 0;
                    }
                    if ((n7 = (n8 & 0xFF00) - (n5 & 0xFF00)) < 0) {
                        n7 = 0;
                    }
                    if ((n6 = (n8 & 0xFF) - (n5 & 0xFF)) < 0) {
                        n6 = 0;
                    }
                    nArray[n4] = n9 + n7 + n6 + -16777216;
                }
                ++n3;
            }
            ++n;
        }
        nArray2 = null;
        System.gc();
        Graphics graphics = image2.getGraphics();
        graphics.drawImage(this.createImage(new MemoryImageSource(this.w, this.h, nArray, 0, this.w)), 0, 0, this.w, this.h, this);
        graphics.finalize();
        graphics = null;
        nArray = null;
        System.gc();
    }
}

